<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Media\V1;

use Twilio\Options;
use Twilio\Values;

abstract class PlayerStreamerOptions {
    /**
     * @param bool $video Whether the PlayerStreamer is configured to stream video
     * @param string $statusCallback The URL to which Twilio will send
     *                               PlayerStreamer event updates
     * @param string $statusCallbackMethod The HTTP method Twilio should use to
     *                                     call the `status_callback` URL
     * @param int $maxDuration Maximum PlayerStreamer duration in seconds
     * @return CreatePlayerStreamerOptions Options builder
     */
    public static function create(bool $video = Values::NONE, string $statusCallback = Values::NONE, string $statusCallbackMethod = Values::NONE, int $maxDuration = Values::NONE): CreatePlayerStreamerOptions {
        return new CreatePlayerStreamerOptions($video, $statusCallback, $statusCallbackMethod, $maxDuration);
    }

    /**
     * @param string $order The sort order of the list
     * @param string $status Status to filter by
     * @return ReadPlayerStreamerOptions Options builder
     */
    public static function read(string $order = Values::NONE, string $status = Values::NONE): ReadPlayerStreamerOptions {
        return new ReadPlayerStreamerOptions($order, $status);
    }
}

class CreatePlayerStreamerOptions extends Options {
    /**
     * @param bool $video Whether the PlayerStreamer is configured to stream video
     * @param string $statusCallback The URL to which Twilio will send
     *                               PlayerStreamer event updates
     * @param string $statusCallbackMethod The HTTP method Twilio should use to
     *                                     call the `status_callback` URL
     * @param int $maxDuration Maximum PlayerStreamer duration in seconds
     */
    public function __construct(bool $video = Values::NONE, string $statusCallback = Values::NONE, string $statusCallbackMethod = Values::NONE, int $maxDuration = Values::NONE) {
        $this->options['video'] = $video;
        $this->options['statusCallback'] = $statusCallback;
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        $this->options['maxDuration'] = $maxDuration;
    }

    /**
     * Specifies whether the PlayerStreamer is configured to stream video. Defaults to `true`.
     *
     * @param bool $video Whether the PlayerStreamer is configured to stream video
     * @return $this Fluent Builder
     */
    public function setVideo(bool $video): self {
        $this->options['video'] = $video;
        return $this;
    }

    /**
     * The URL to which Twilio will send asynchronous webhook requests for every PlayerStreamer event. See [Status Callbacks](/docs/live/status-callbacks) for more details.
     *
     * @param string $statusCallback The URL to which Twilio will send
     *                               PlayerStreamer event updates
     * @return $this Fluent Builder
     */
    public function setStatusCallback(string $statusCallback): self {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * The HTTP method Twilio should use to call the `status_callback` URL. Can be `POST` or `GET` and the default is `POST`.
     *
     * @param string $statusCallbackMethod The HTTP method Twilio should use to
     *                                     call the `status_callback` URL
     * @return $this Fluent Builder
     */
    public function setStatusCallbackMethod(string $statusCallbackMethod): self {
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        return $this;
    }

    /**
     * The maximum time, in seconds, that the PlayerStreamer can run before automatically ends. The default value is 300 seconds, and the maximum value is 90000 seconds. Once this maximum duration is reached, Twilio will end the PlayerStreamer, regardless of whether media is still streaming. **Note: this feature has not yet been enabled but customers are advised to explicitly set it on all their new PlayerStreamer resources.**
     *
     * @param int $maxDuration Maximum PlayerStreamer duration in seconds
     * @return $this Fluent Builder
     */
    public function setMaxDuration(int $maxDuration): self {
        $this->options['maxDuration'] = $maxDuration;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Media.V1.CreatePlayerStreamerOptions ' . $options . ']';
    }
}

class ReadPlayerStreamerOptions extends Options {
    /**
     * @param string $order The sort order of the list
     * @param string $status Status to filter by
     */
    public function __construct(string $order = Values::NONE, string $status = Values::NONE) {
        $this->options['order'] = $order;
        $this->options['status'] = $status;
    }

    /**
     * The sort order of the list by `date_created`. Can be: `asc` (ascending) or `desc` (descending) with `desc` as the default.
     *
     * @param string $order The sort order of the list
     * @return $this Fluent Builder
     */
    public function setOrder(string $order): self {
        $this->options['order'] = $order;
        return $this;
    }

    /**
     * Status to filter by, with possible values `created`, `started`, `ended`, or `failed`.
     *
     * @param string $status Status to filter by
     * @return $this Fluent Builder
     */
    public function setStatus(string $status): self {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Media.V1.ReadPlayerStreamerOptions ' . $options . ']';
    }
}